// -------------------------------------------------------------------
// ------------- Autor: Patrick Saar - www.patrick-saar.de -----------
// ---------------- JS Placeholder Fallback v. 1.1 -------------------
// ------------------ Copyright 2013 Patrick Saar --------------------
// -------------------------------------------------------------------

var placeholder = {
    init: function (color, defaultColor) {
        var tags = new Array('input', 'textarea');
        for (var i = tags.length; i--; ) {
            this.setPlaceholder(tags[i], color);
            this.focus(tags[i], defaultColor);
            this.blur(tags[i], color);
            this.submit(tags[i]);
        }
    },
    setPlaceholder: function (tagName, color) {
        var tag = document.getElementsByTagName(tagName);
        for (var i = tag.length; i--; ) {
            if (tag[i].getAttribute('placeholder') !== null) {
                tag[i].value = tag[i].getAttribute('placeholder');
                tag[i].style.color = color;
            }
        }
    },
    focus: function (tagName, color) {
        var tag = document.getElementsByTagName(tagName);
        for (var i = tag.length; i--; ) {
            if (tag[i].getAttribute('placeholder') !== null) {
                tag[i].onfocus = function () {
                    if (this.value === this.getAttribute('placeholder')) {
                        this.value = '';
                        this.style.color = color;
                    }
                };
            }
        }
    },
    blur: function (tagName, color) {
        var tag = document.getElementsByTagName(tagName);
        for (var i = tag.length; i--; ) {
            if (tag[i].getAttribute('placeholder') !== null) {
                tag[i].onblur = function () {
                    if (this.value === '') {
                        this.value = this.getAttribute('placeholder');
                        this.style.color = color;
                    }
                };
            }
        }
    },
    submit: function (tagName) {
        var tag = document.getElementsByTagName(tagName);
        var forms = document.getElementsByTagName('form');
        for (var j = forms.length; j--; ) {
            forms[j].onsubmit = function () {
                for (var i = tag.length; i--; ) {
                    if (tag[i].getAttribute('placeholder') !== null) {
                        if (tag[i].value === tag[i].getAttribute('placeholder')) {
                            tag[i].value = '';
                        }
                    }
                }
            };
        }
    }
};

window.onload = function() {
    placeholder.init('#999', '#000'); // Placeholder Ersatz anwenden.
                                      // Parameter 1: Schriftfarbe Platzhalter
                                      // Parameter 2: Schriftfarbe bei Eingabe
};