// -------------------------------------------------------------------
// ------------- Autor: Patrick Saar - www.patrick-saar.de -----------
// ------------ jQuery Plugin - Delayed Hover Effect v. 1.0 ----------
// ------------------ Copyright 2012 Patrick Saar --------------------
// -------------------------------------------------------------------

(function ($) {
    $.fn.delayedHoverEffect = function (delayIn, handlerIn, delayOut, handlerOut) {
        return this.each(function () {
            var timeout1, timeout2;
            $(this).hover(function () {
                clearTimeout(timeout2);
                timeout2 = null;
                timeout1 = setTimeout(function () { handlerIn(); }, delayIn);
            },
            function () {
                clearTimeout(timeout1);
                timeout1 = null;
                timeout2 = setTimeout(function () { handlerOut(); }, delayOut);
            });
        });
    }
})(jQuery);

$('#delayed-hover-div').delayedHoverEffect(1000, function () { $('#div').css({'background': '#f00'}); }, 500, function () { $('#delayed-hover-div').css({'background': '#000'}); });