// -------------------------------------------------------------------
// ------------- Autor: Patrick Saar - www.patrick-saar.de -----------
// ------------- jQuery Plugin - Individual tooltip v. 1.0 -----------
// ------------------ Copyright 2012 Patrick Saar --------------------
// -------------------------------------------------------------------

(function ($) {
    $.fn.details = function (settings) {
        return this.each(function () {
            // Global variables
            var parent = $(this);
            var timeout;

            // Set required selectors
            var attributes = {
                wrapper: {
                    id: 'jquery-plugin-details',
                    jquery: '#jquery-plugin-details'
                },
                arrow: {
                    id: 'jquery-plugin-details-arrow',
                    jquery: '#jquery-plugin-details-arrow'
                },
                rect: {
                    id: 'jquery-plugin-details-rect',
                    jquery: '#jquery-plugin-details-rect'
                }
            };

            var init = {
                // Tooltip data
                data: parent.attr('title'),
                // Set default values, if property is not set
                setDefaults: function () {
                    if (settings.arrow.width == null) settings.arrow.width = 20;
                    if (settings.arrow.color == null) settings.arrow.color = '#ccc';
                    if (settings.arrow.direction == null) settings.arrow.direction = 'up';
                    if (settings.arrow.pos == null) settings.arrow.pos = 0;
                    if (settings.pos.x == null) settings.pos.x = parent.width() / 2;
                    if (settings.pos.y == null) settings.pos.y = parent.height() / 2;
                    if (settings.cssRect == null) settings.cssRect = {};
                    if (settings.delayHover == null) settings.delayHover = 100;
                    if (settings.fade == null) settings.fade = 100;
                },
                // Converts arrow direction to a css triangle code
                directionToCSS: function (direction) {
                    var css;
                    if (direction === 'left')
                        css = 'transparent' + settings.arrow.color + ' transparent transparent';
                    else if (direction === 'right')
                        css = 'transparent transparent transparent' + settings.arrow.color;
                    else if (direction === 'down')
                        css = settings.arrow.color + ' transparent transparent transparent';
                    else
                        css = 'transparent transparent ' + settings.arrow.color + ' transparent';
                    return css;
                },
                // Position of tooltip rectangle relative to the triangle
                posRect: function (direction) {
                    var x, y;
                    if (direction === 'left') {
                        x = settings.arrow.width * 2;
                        y = -settings.arrow.width * 2 - settings.arrow.pos;
                    }
                    else if (direction === 'right') {
                        x = -$(attributes.rect.jquery).outerWidth();
                        y = -settings.arrow.width * 2 - settings.arrow.pos;
                    }
                    else if (direction === 'down') {
                        x = -settings.arrow.pos;
                        y = -$(attributes.rect.jquery).outerHeight() - settings.arrow.width * 2;
                    }
                    else {
                        x = -settings.arrow.pos;
                        y = 0;
                    }
                    return { top: y, left: x };
                },
                // Enables negative value for arrow.pos 
                // Negative value positioning triangle relative to the right (for arrow directions up/down) or bottom (for arrow directions left/right) of the rectangle
                posArrow: function (pos, direction) {
                    var dimRect;
                    if (direction === 'up' || direction === 'down')
                        dimRect = $(attributes.rect.jquery).outerWidth();
                    else
                        dimRect = $(attributes.rect.jquery).outerHeight();
                    pos = (pos < 0) ? (dimRect + pos - settings.arrow.width * 2) : pos;
                    return pos;
                }
            };

            // Set default CSS values of the tooltip
            var cssDefaults = {
                wrapper: function () {
                    $(attributes.wrapper.jquery).css({
                        'position': 'absolute',
                        'z-index': 100000000,
                        'top': settings.pos.y - settings.arrow.width,
                        'left': settings.pos.x - settings.arrow.width
                    });
                },
                arrow: function () {
                    $(attributes.arrow.jquery).css({
                        'width': 0,
                        'height': 0,
                        'border-width': settings.arrow.width,
                        'border-style': 'solid',
                        'border-color': init.directionToCSS(settings.arrow.direction)
                    });
                },
                rect: function () {
                    $(attributes.rect.jquery).css({
                        'background': '#ccc'
                    });
                },
                rectPos: function () {
                    $(attributes.rect.jquery).css({
                        'position': 'relative',
                        'top': init.posRect(settings.arrow.direction).top,
                        'left': init.posRect(settings.arrow.direction).left
                    });
                }
            };
            
            // Converts HTML entities to HTML markup
            var text = {
                htmlEntities: function (str) {
                    str = str.replace('&lt;', '<');
                    str = str.replace('&gt;', '>');
                    str = str.replace('&quot;', '"');
                    return str;
                }
            };

            // Mouse interaction for hover()
            var mouse = {
                enter: function () {
                    if (parent.css('position') !== 'absolute' && parent.css('position') !== 'fixed') parent.css({ 'position': 'relative' });
                    init.setDefaults();
                    $('<div id="' + attributes.wrapper.id + '"><div id="' + attributes.arrow.id + '"></div><div id="' + attributes.rect.id + '">' + text.htmlEntities(init.data) + '</div></div>').fadeIn(settings.fade).appendTo(parent);
                    // CSS default styling
                    cssDefaults.wrapper();
                    cssDefaults.arrow();
                    cssDefaults.rect();
                    settings.arrow.pos = init.posArrow(settings.arrow.pos, settings.arrow.direction);

                    // CSS individual styling
                    $(attributes.rect.jquery).css(settings.cssRect);

                    cssDefaults.rectPos();
                },
                leave: function () {
                    $(attributes.wrapper.jquery).fadeOut(settings.fade / 2, function () {
                        parent.attr({ 'title': init.data });
                        $(this).remove();
                    });
                }
            };

            // Executes mouse interaction, which is described above
            parent.hover(function () {
                if (!init.data) return;
                parent.attr({ 'title': '' });
                timeout = setTimeout(function () { mouse.enter(); }, settings.delayHover);
            },
            function () {
                if (!init.data) return;
                clearTimeout(timeout);
                timeout = null;
                mouse.leave();
            });

        });
    }
})(jQuery)