/********************************************************/
/*                 PS-Image-Gallery                     */
/*      (c) Patrick Saar - www.patrick-saar.de          */
/*                   Version 1.2                        */
/*          last modification: 22.12.2012               */
/*          Licensed under CC BY-NC-SA 3.0              */
/* http://creativecommons.org/licenses/by-nc-sa/3.0/de/ */
/*------------------------------------------------------*/
/*                    JavaScript                        */
/********************************************************/

/******************** Settings **************************/
var psIGSettings = {
    controls: true, /* boolean - display controlbar */
    imageChange: 4000,  /* integer - Time, how long a photo should be shown before changing in milliseconds */
    titleOn: true, /* boolean - Show title at the beginning */
    randomize: true, /* boolean - Random images */
    thumbnailsOn: true, /* boolean - Show thumbnails */
    thumbnailsStartShow: true, /* boolean - Show thumbnails at the beginning */
    keyboardActivate: true, /* boolean - Scroll photos with keyboard arrows */
    autoplay: false, /* boolean - Autoplay diashow */
    scaleNormalPhotosBigger: true, /* boolean - Resize smaller photos for gallery */
    scaleFullscreenPhotosBigger: true /* boolean - Resize smaller photos for fullscreen */
};

var psIGVelocity = {
    toggle: 400, /* integer - Time, how long thumbnailbar should toggle in milliseconds */
    fade: 800, /* integer - Time, how long image fade action takes in milliseconds */
    delayFadeESC: 2000, /* integer - Time, how long fullscreen close info should be displayed in milliseconds */
    delayToggleThumbnails: 2000, /* integer - Time, how long thumbnailbar should be displayed after onload the gallery in milliseconds */
    slideThumbnails: 400 /* integer - Time, how long thumbnail scrolling should take in milliseconds */
};

var psIGDescriptions = {
    titleSuffix: 'Photo ', /* string - Suffix of image title (e.g.: 'Photo '). If string is empty, number of the photo don't appear in the suffix of the title */
    leavingNote: 'Zum Verlassen \'ESC\' dr&uuml;cken' /* Note how to leave the fullscreen mode */
}

/*******  Don't change anything after this line  *******/
/****************** DOM Elements, which will be manipulated *************************/
var psIGDOM = {
    idPause: jQuery('#ps-image-gallery-pause'),
    idPlay: jQuery('#ps-image-gallery-play'),
    idPrev: jQuery('#ps-image-gallery-prev'),
    idNext: jQuery('#ps-image-gallery-next'),
    idControls: jQuery('#ps-image-gallery-controlbar'),
    idThumbs: jQuery('#ps-image-gallery-thumbnails'),
    idThumbsInner: jQuery('#ps-image-gallery-thumbnails-inner'),
    idThumbsOuter: jQuery('#ps-image-gallery-thumbnails-outer'),
    idThumbsLeft: jQuery('#ps-image-gallery-thumbnails-left'),
    idThumbsRight: jQuery('#ps-image-gallery-thumbnails-right'),
    idGallery: jQuery('#ps-image-gallery-gallery'),
    idDisplay: jQuery('#ps-image-gallery-display'),
    idTitle: jQuery('#ps-image-gallery-title'),
    idSlider: jQuery('#ps-image-gallery-slider'),
    idSliderbutton: jQuery('#ps-image-gallery-sliderbutton'),
    idTitleOff: jQuery('#ps-image-gallery-title-off'),
    idTitleOn: jQuery('#ps-image-gallery-title-on'),
    idFullscreenOn: jQuery('#ps-image-gallery-fullscreen-on'),
    idFullscreenOff: jQuery('#ps-image-gallery-fullscreen-off'),
    idCurrentphoto: jQuery('#ps-image-gallery-currentphoto'),
    idShowInfo: jQuery('#ps-image-gallery-showinfo'),
    idInfo: jQuery('#ps-image-gallery-info'),
    idLoadingCircle: jQuery('#ps-image-gallery-loading-circle'),
    images: jQuery('#ps-image-gallery-images img'),
    newDiv: jQuery('<div></div>'),
    newImg: jQuery('<img />'),
    body: jQuery('body')
}

var psIGDOMstrings = {
    small: 'ps-image-gallery-small',
    normal: 'ps-image-gallery-normal',
    big: 'ps-image-gallery-big',
    smallID: '#ps-image-gallery-small',
    normalID: '#ps-image-gallery-normal',
    bigID: '#ps-image-gallery-big'
}

/********* Global variables ***************/
var psIGGlobals = {
    currentPhoto: 0,
    countPhotos: 0,
    orderPhotos: [],
    isMouseover: false,
    toggletimer: 0,
    marginThumbs: 20,
    isFullscreen: false,
    isInfo: false,
    isTitle: psIGSettings.titleOn,
    controlsActivate: true,
    loaded: false,
    played: false
}

/********* methods, which will executed only when the DOM is ready **************/
var psIGinit = {
    randomize: function (count, randomize) {
        var i, random1, random2, temp;
        for (i = count; i--; ) {
            psIGGlobals.orderPhotos[i] = i;
        }
        if (randomize) {
            for (i = (count * 3); i--; ) {
                random1 = Math.floor(Math.random() * count);
                random2 = Math.floor(Math.random() * count);
                temp = psIGGlobals.orderPhotos[random1];
                psIGGlobals.orderPhotos[random1] = psIGGlobals.orderPhotos[random2];
                psIGGlobals.orderPhotos[random2] = temp;
            }
        }
    },
    photoshowReady: function () {
        if (psIGSettings.controls) {
            psIGDOM.idControls.show();
        }
        var count = psIGDOM.images.length;
        var text = '1 / ' + count;
        psIGDOM.idCurrentphoto.html(text);
        psIGDOM.idInfo.html('PS-Image-Gallery<br />Programmed by: Patrick Saar<br />Version: 1.2<br /><a href="http://www.patrick-saar.de" target="_blank" id="programmerlink">www.patrick-saar.de</a>');
        return count;
    },
    mouseposition: function () {
        psIGDOM.idGallery.mousemove(function (e) { psIGGlobals.isMouseover = true; });
    },
    title: function () {
        if (!psIGSettings.titleOn) psIGControls.titleOff(0);
    },
    thumbnails: function () {
        if (!psIGSettings.thumbnailsStartShow) psIGDOM.idThumbs.slideToggle(0);
    },
    cssSize: function () {
        var width = psIGDOM.idGallery.width();
        var height = psIGDOM.idDisplay.height();
        psIGDOM.idTitle.css({ 'width': width });
        psIGDOM.idThumbs.css({ 'width': width });
        psIGDOM.idThumbsOuter.css({ 'width': width - 64 });
        psIGDOM.idLoadingCircle.css({ 'width': width, 'height': height });
    }
}

var psIGmethods = {
    scalePhoto: function (no, width, height) {
        var DOM;
        var fullscreen = psIGGlobals.isFullscreen;
        if (!fullscreen) DOM = psIGDOMstrings.normalID;
        else DOM = psIGDOMstrings.bigID;
        var obj = jQuery(DOM + no);
        var photoWidth = obj.width();
        var photoHeight = obj.height();
        if (!photoWidth || !photoHeight || !width || !height) {
            setTimeout(function () { scalePhoto(no, width, height); }, 10);
        }
        else {
            obj.css({ 'width': 'auto', 'height': 'auto' });
            if (photoWidth / width < photoHeight / height) {
                if (photoHeight >= height || (psIGSettings.scaleNormalPhotosBigger && !fullscreen) || (psIGSettings.scaleFullscreenPhotosBigger && fullscreen)) {
                    obj.css({
                        'width': photoWidth * (height / photoHeight),
                        'height': height,
                        'margin-left': -(photoWidth * (height / photoHeight)) / 2,
                        'margin-top': -height / 2
                    });
                }
            }
            else {
                if (photoWidth >= width || (psIGSettings.scaleNormalPhotosBigger && !fullscreen) || (psIGSettings.scaleFullscreenPhotosBigger && fullscreen)) {
                    obj.css({
                        'width': width,
                        'height': photoHeight * (width / photoWidth),
                        'margin-left': -width / 2,
                        'margin-top': -(photoHeight * (width / photoWidth)) / 2
                    });
                }
            }
        }
    },
    toggleThumbnails: function (timeout, toggle) {
        psIGGlobals.toggletimer = setTimeout(function () { psIGDOM.idThumbs.stop().slideToggle(toggle, function () { psIGGlobals.toggletimer = false; }) }, timeout);
    },
    getTitle: function (no) {
        var obj = psIGDOM.idTitle;
        var title = psIGDOM.images.eq(no).attr('data-title');
        if (!title || !psIGGlobals.isTitle) obj.hide();
        else obj.show();
        obj.html(title);
    },
    controlsInactive: function (timeout) {
        psIGGlobals.controlsActivate = false;
        setTimeout(function () { psIGGlobals.controlsActivate = true; }, timeout)
    }
}

var psIGPhotoCreate = {
    small: function (count) {
        var title, src;
        var img = psIGDOM.newImg;
        for (var i = count; i--; ) {
            img.clone().prependTo('#ps-image-gallery-thumbnails-inner');
        }
        var image = jQuery('#ps-image-gallery-thumbnails-inner img');
        var i = 0, img1, img2;
        for (i = count; i--; ) {
            img1 = psIGDOM.images.eq(psIGGlobals.orderPhotos[i]);
            img2 = image.eq(i);
            title = img1.attr('data-title');
            src = img1.attr('data-small-src');
            if (psIGDescriptions.titleSuffix !== '') {
                img2.attr({ 'title': psIGDescriptions.titleSuffix + ' ' + (i + 1) + ' - ' + title });
            }
            else {
                img2.attr({ 'title': title });
            }
            img2.attr({ 'src': src, 'id': psIGDOMstrings.small + i });
            img2.click(function () { psIGThumbnailsControl.clicked(jQuery(this).index()); });
        }
        jQuery(window).load(function () {
            var w = 0, img2, margin = psIGGlobals.marginThumbs;
            for (i = 0; i < count; i++) {
                img2 = image.eq(i);
                img2.attr({ 'data-left': -w });
                w += img2.width() + margin;
            }
            psIGDOM.idThumbsInner.css({ 'width': w });
        });
    },
    normal: function () {
        var src;
        var cu = psIGGlobals.currentPhoto;
        var co = psIGGlobals.countPhotos;
        var j, img1;
        var img = psIGDOM.newImg;
        for (var i = cu - 1; i <= cu + 3; i++) {
            if (i < 0) j = co - 1;
            else if (i > co) j = 0;
            else j = i;
            img1 = psIGDOM.images.eq(psIGGlobals.orderPhotos[j]);
            if (jQuery(psIGDOMstrings.normalID + j).length === 0) {
                if (img1.attr('data-normal-src')) {
                    src = img1.attr('data-normal-src');
                    img.attr({ 'src': src, 'id': psIGDOMstrings.normal + j }).clone().prependTo('#ps-image-gallery-display').hide();
                }
                else if (img1.attr('data-big-src')) {
                    src = img1.attr('data-big-src');
                    img.attr({ 'src': src, 'id': psIGDOMstrings.normal + j }).clone().prependTo('#ps-image-gallery-display').hide();
                }
                else {
                    src = img1.attr('data-small-src');
                    img.attr({ 'src': src, 'id': psIGDOMstrings.normal + j }).clone().prependTo('#ps-image-gallery-display').hide();
                }
            }
        }
        jQuery(psIGDOMstrings.normalID + cu).bind('load', function () {
            if (!psIGGlobals.loaded) loaded();
        });
    },
    big: function () {
        var src;
        var cu = psIGGlobals.currentPhoto;
        var co = psIGGlobals.countPhotos;
        var j, img1;
        var img = psIGDOM.newImg;
        for (var i = cu - 1; i <= cu + 3; i++) {
            if (i < 0) j = co - 1;
            else if (i > co) j = 0;
            else j = i;
            img1 = psIGDOM.images.eq(psIGGlobals.orderPhotos[j]);
            if (jQuery(psIGDOMstrings.bigID + j).length === 0) {
                if (img1.attr('data-big-src')) {
                    src = img1.attr('data-big-src');
                    img.attr({ 'src': src, 'id': psIGDOMstrings.big + j }).clone().prependTo('#ps-image-gallery-fullscreen-bg').hide();
                }
                else if (img1.attr('data-normal-src')) {
                    src = img1.attr('data-normal-src');
                    img.attr({ 'src': src, 'id': psIGDOMstrings.big + j }).clone().prependTo('#ps-image-gallery-fullscreen-bg').hide();
                }
                else {
                    src = img1.attr('data-small-src');
                    img.attr({ 'src': src, 'id': psIGDOMstrings.big + j }).clone().prependTo('#ps-image-gallery-fullscreen-bg').hide();
                }
            }
        }
    }
}

/***************** Controlbar Interaction ****************/
var psIGControls = {
    timeout: false,
    play: function () {
        var display = psIGDOM.idDisplay;
        var win = jQuery(window);
        psIGDOM.idPause.show();
        psIGDOM.idPlay.hide();
        psIGGlobals.played = true;
        this.timeout = setTimeout(function () {
            if (!psIGGlobals.isFullscreen) psIGControls.next(true, psIGDOMstrings.normalID, display.width(), display.height());
            else psIGControls.next(true, psIGDOMstrings.bigID, win.width(), win.height());
            psIGControls.play();
        }, (psIGSettings.imageChange));
    },
    pause: function () {
        psIGDOM.idPlay.show();
        psIGDOM.idPause.hide();
        psIGGlobals.played = false;
        if (this.timeout) clearTimeout(this.timeout);
    },
    next: function (stopDia, DOM, width, height) {
        psIGPhotoCreate.normal();
        var i = psIGGlobals.currentPhoto;
        var j = i;
        var fade = psIGVelocity.fade;
        var count = psIGGlobals.countPhotos;
        var circle = psIGDOM.idLoadingCircle;
        if (stopDia) {
            this.pause();
        }
        jQuery(psIGDOMstrings.smallID + j).css({ 'width': 'auto' });
        i++;
        if (i >= count) {
            i = 0;
        }
        circle.show();
        var id = jQuery(DOM + i);
        jQuery.when(id.bind('load')).then(function () {
            var text = (i + 1) + ' / ' + count;
            var ti = psIGDOM.idThumbsInner;
            var to = psIGDOM.idThumbsOuter;
            psIGDOM.idCurrentphoto.html(text);
            psIGmethods.scalePhoto(i, width, height);
            var x = jQuery(psIGDOMstrings.smallID + i).attr('data-left');
            if (-x > ti.width() - to.width()) {
                x = -(ti.width() - to.width());
            }
            ti.animate({ 'left': x }, psIGVelocity.slideThumbnails);
            circle.hide();
            jQuery(DOM + j).fadeOut(fade);
            id.fadeIn(fade);
            psIGmethods.getTitle(psIGGlobals.orderPhotos[i]);
        });
        psIGGlobals.currentPhoto = i;
        if (psIGGlobals.isFullscreen) psIGPhotoCreate.big();
    },
    prev: function (stopDia, DOM, width, height) {
        psIGPhotoCreate.normal();
        var i = psIGGlobals.currentPhoto;
        var j = i;
        var fade = psIGVelocity.fade;
        var count = psIGGlobals.countPhotos;
        var circle = psIGDOM.idLoadingCircle;
        if (stopDia) {
            this.pause();
        }
        jQuery(psIGDOMstrings.smallID + j).css({ 'width': 'auto' });
        i--;
        if (i < 0) {
            i = count - 1;
        }
        circle.show();
        var id = jQuery(DOM + i);
        jQuery.when(id.bind('load')).then(function () {
            var text = (i + 1) + ' / ' + count;
            var ti = psIGDOM.idThumbsInner;
            var to = psIGDOM.idThumbsOuter;
            psIGDOM.idCurrentphoto.html(text);
            psIGmethods.scalePhoto(i, width, height);
            var x = jQuery(psIGDOMstrings.smallID + i).attr('data-left');
            if (-x > ti.width() - to.width()) {
                x = -(ti.width() - to.width());
            }
            ti.animate({ 'left': x }, psIGVelocity.slideThumbnails);
            circle.hide();
            jQuery(DOM + j).fadeOut(fade);
            id.fadeIn(fade);
            psIGmethods.getTitle(psIGGlobals.orderPhotos[i]);
        });
        psIGGlobals.currentPhoto = i;
        if (psIGGlobals.isFullscreen) psIGPhotoCreate.big();
    },
    titleOff: function (fade) {
        if (!fade) fade = psIGVelocity.fade
        psIGDOM.idTitleOn.show();
        psIGDOM.idTitleOff.hide();
        psIGDOM.idTitle.fadeOut(fade);
        psIGGlobals.isTitle = false;
    },
    titleOn: function () {
        psIGDOM.idTitleOff.show();
        psIGDOM.idTitleOn.hide();
        psIGDOM.idTitle.fadeIn(psIGVelocity.fade);
        psIGGlobals.isTitle = true;
    },
    fullscreen: function (open) {
        var current, played;
        if (psIGGlobals.played) {
            this.pause();
            played = true;    
        }
        if (open) {
            var win = jQuery(window);
            jQuery('<div id="ps-image-gallery-fullscreen-bg"><div id="ps-image-gallery-fullscreen-esc">' + psIGDescriptions.leavingNote + '</div></div>').appendTo('body');
            jQuery('<div id="ps-image-gallery-loading-circle-fullscreen"><img src="images/ps-image-gallery-loader.gif" /></div>').show().appendTo('#ps-image-gallery-fullscreen-bg');
            psIGDOM.body.css({ 'overflow': 'hidden' });
            psIGPhotoCreate.big();
            psIGDOM.idControls.prependTo('#ps-image-gallery-fullscreen-bg').css({ 'position': 'absolute', 'left': 0, 'bottom': 0, 'z-index': '1000001' });
            psIGDOM.idInfo.prependTo('#ps-image-gallery-fullscreen-bg').css({ 'bottom': 30 });
            psIGDOM.idTitle.prependTo('#ps-image-gallery-fullscreen-bg').css({ 'width': '100%', 'z-index': '1000001' });
            jQuery('#ps-image-gallery-fullscreen-esc').delay(psIGVelocity.delayFadeESC).fadeOut(psIGVelocity.fade);
            psIGGlobals.isFullscreen = true;
            psIGDOM.idFullscreenOff.show();
            psIGDOM.idFullscreenOn.hide();
            current = psIGGlobals.currentPhoto;
            jQuery(psIGDOMstrings.bigID + current).bind('load', function () {
                psIGmethods.scalePhoto(current, win.width(), win.height());
                jQuery('#ps-image-gallery-loading-circle-fullscreen').hide();
                jQuery(psIGDOMstrings.bigID + current).show();
                if (played) {
                    this.play();   
                }
            });
        }
        else {
            var display = psIGDOM.idDisplay;
            psIGDOM.body.css({ 'overflow': 'auto' });
            psIGGlobals.isFullscreen = false;
            jQuery('#ps-image-gallery-display > img').hide();
            current = psIGGlobals.currentPhoto;
            jQuery(psIGDOMstrings.normalID + current).show();
            psIGmethods.scalePhoto(current, display.width(), display.height());
            psIGDOM.idControls.prependTo('#ps-image-gallery-controlbar-wrapper').css({ 'position': '', 'left': '', 'bottom': '', 'z-index': '' });
            psIGDOM.idInfo.prependTo('#ps-image-gallery-info-wrapper').css({ 'bottom': 0 });
            psIGDOM.idTitle.prependTo('#ps-image-gallery-display').css({ 'width': display.css('width'), 'z-index': '99' });
            jQuery('#ps-image-gallery-fullscreen-bg').remove();
            psIGDOM.idFullscreenOn.show();
            psIGDOM.idFullscreenOff.hide();
            if (played) {
                this.play();   
            }
        }
    },
    showInfo: function () {
        if (!psIGGlobals.isInfo) {
            psIGDOM.idInfo.fadeIn(psIGVelocity.fade, function () { psIGGlobals.isInfo = true; });
        }
        else {
            psIGDOM.idInfo.fadeOut(psIGVelocity.fade, function () { psIGGlobals.isInfo = false; });
        }
    }
}

/****************** Thumbnailscontrol Interaction *******************/
var psIGThumbnailsControl = {
    left: function () {
        psIGPhotoCreate.normal();
        var innerWidth = psIGDOM.idThumbsInner.width();
        var outerWidth = psIGDOM.idThumbsOuter.width();
        if (innerWidth > outerWidth) {
            var x = parseInt(psIGDOM.idThumbsInner.css('left'));
            x = x + 0.75 * outerWidth;
            if (x > 0) x = 0;
            psIGDOM.idThumbsInner.animate({ 'left': x }, psIGVelocity.slideThumbnails);
        }
    },
    right: function () {
        psIGPhotoCreate.normal();
        var innerWidth = psIGDOM.idThumbsInner.width();
        var outerWidth = psIGDOM.idThumbsOuter.width();
        if (innerWidth > outerWidth) {
            var x = parseInt(psIGDOM.idThumbsInner.css('left'));
            x = x - 0.75 * outerWidth;
            if (x < (-innerWidth + outerWidth)) x = -innerWidth + outerWidth;
            psIGDOM.idThumbsInner.animate({ 'left': x }, psIGVelocity.slideThumbnails);
        }
    },
    clicked: function (clickedPhoto) {
        if (psIGGlobals.currentPhoto !== clickedPhoto) {
            var i = psIGGlobals.currentPhoto;
            var obj = jQuery(psIGDOMstrings.normalID + clickedPhoto);
            var circle = psIGDOM.idLoadingCircle;
            psIGGlobals.currentPhoto = clickedPhoto;
            psIGControls.pause();
            psIGPhotoCreate.normal();
            jQuery(psIGDOMstrings.normalID + i).fadeOut(psIGVelocity.fade);
            circle.show();
            jQuery.when(obj.bind('load')).then(function () {
                var text = (clickedPhoto + 1) + ' / ' + psIGGlobals.countPhotos;
                var display = psIGDOM.idDisplay;
                psIGDOM.idCurrentphoto.html(text);
                psIGmethods.scalePhoto(clickedPhoto, display.width(), display.height());
                circle.hide();
                jQuery(psIGDOMstrings.normalID + clickedPhoto).fadeIn(psIGVelocity.fade);
                psIGmethods.getTitle(psIGGlobals.orderPhotos[clickedPhoto]);
            });
        }
    }
}

/***************** Click-Handler **************************/
psIGDOM.idPlay.click(function () { if(psIGGlobals.controlsActivate) psIGControls.play(); psIGmethods.controlsInactive(psIGVelocity.fade); });
psIGDOM.idPause.click(function () { if(psIGGlobals.controlsActivate) psIGControls.pause(); psIGmethods.controlsInactive(psIGVelocity.fade); });
psIGDOM.idNext.click(function () {
    if (psIGGlobals.controlsActivate) {
        var display = psIGDOM.idDisplay;
        var win = jQuery(window);
        if (!psIGGlobals.isFullscreen) psIGControls.next(true, psIGDOMstrings.normalID, display.width(), display.height());
        else psIGControls.next(true, psIGDOMstrings.bigID, win.width(), win.height());
    }
    psIGmethods.controlsInactive(psIGVelocity.fade);
});
psIGDOM.idPrev.click(function () {
    if (psIGGlobals.controlsActivate) {
        var display = psIGDOM.idDisplay;
        var win = jQuery(window);
        if (!psIGGlobals.isFullscreen) psIGControls.prev(true, psIGDOMstrings.normalID, display.width(), display.height());
        else psIGControls.prev(true, psIGDOMstrings.bigID, win.width(), win.height());
    }
    psIGmethods.controlsInactive(psIGVelocity.fade);
});
psIGDOM.idTitleOff.click(function () { psIGControls.titleOff(); });
psIGDOM.idTitleOn.click(function () { psIGControls.titleOn(); });
psIGDOM.idFullscreenOn.click(function () { psIGControls.fullscreen(true); });
psIGDOM.idFullscreenOff.click(function () { psIGControls.fullscreen(false); });
psIGDOM.idShowInfo.click(function () { psIGControls.showInfo(); });
psIGDOM.idThumbsLeft.click(function () { if (psIGGlobals.controlsActivate) psIGThumbnailsControl.left(); psIGmethods.controlsInactive(psIGVelocity.slideThumbnails); });
psIGDOM.idThumbsRight.click(function () { if (psIGGlobals.controlsActivate) psIGThumbnailsControl.right(); psIGmethods.controlsInactive(psIGVelocity.slideThumbnails); });

/************** Mouse-Handler ***************************/
psIGDOM.idDisplay.hover(
    function () {
        if (psIGDOM.idThumbs.css('display') === 'none' && psIGSettings.thumbnailsOn) {
            psIGmethods.toggleThumbnails(0, psIGVelocity.toggle)
        }
    },
    function () {
        if (psIGDOM.idThumbs.css('display') !== 'none' && psIGSettings.thumbnailsOn) {
            psIGmethods.toggleThumbnails(0, psIGVelocity.toggle)
        }
    }
);

/*************** Keyboard-Handler ***********************/
    jQuery(document).keyup(function (e) {
        if (psIGGlobals.controlsActivate) {
            var f = psIGGlobals.isFullscreen;
            var ka = psIGSettings.keyboardActivate;
            var kc = e.keyCode;
            if (kc == 27 && f) { psIGControls.fullscreen(false); }
            else if (kc == 37 && ka && !f) { var display = psIGDOM.idDisplay; psIGControls.prev(true, psIGDOMstrings.normalID, display.width(), display.height()); }
            else if (kc == 39 && ka && !f) { var display = psIGDOM.idDisplay; psIGControls.next(true, psIGDOMstrings.normalID, display.width(), display.height()); }
            else if (kc == 37 && ka && f) { var win = jQuery(window); psIGControls.prev(true, psIGDOMstrings.bigID, win.width(), win.height()); }
            else if (kc == 39 && ka && f) { var win = jQuery(window); psIGControls.next(true, psIGDOMstrings.bigID, win.width(), win.height()); }
            psIGmethods.controlsInactive(psIGVelocity.fade);
        }
    });

/***************** Resize browser window *******/
jQuery(window).resize(function () {
    if(psIGGlobals.isFullscreen) psIGmethods.scalePhoto(psIGGlobals.currentPhoto, jQuery(window).width(), jQuery(window).height());
});

/******* PS-Image-Gallery ready ********/
jQuery(document).ready(function () {
    psIGDOM.idLoadingCircle.show();
    if (psIGSettings.autoplay) psIGGlobals.played = true;
    psIGDOM.idThumbs.show();
    psIGinit.cssSize();
    psIGinit.title();
    psIGGlobals.countPhotos = psIGinit.photoshowReady();
    psIGinit.randomize(psIGGlobals.countPhotos, psIGSettings.randomize);
    psIGPhotoCreate.small(psIGGlobals.countPhotos);
    psIGPhotoCreate.normal();
    psIGmethods.getTitle(psIGGlobals.orderPhotos[0]);
});

function loaded() {
    psIGmethods.scalePhoto(0, psIGDOM.idDisplay.width(), psIGDOM.idDisplay.height());
    psIGDOM.idLoadingCircle.hide();
    jQuery(psIGDOMstrings.normalID + '0').show();
    if (psIGSettings.thumbnailsStartShow) psIGmethods.toggleThumbnails(psIGVelocity.delayToggleThumbnails, psIGVelocity.toggle);
    else psIGDOM.idThumbs.hide();
    if (psIGSettings.autoplay) psIGControls.play();
    psIGGlobals.loaded = true;
}