/********************************************************/
/*                 PS-Image-Gallery                     */
/*      (c) Patrick Saar - www.patrick-saar.de          */
/*                   Version 1.2                        */
/*          last modification: 22.12.2012               */
/*          Licensed under CC BY-NC-SA 3.0              */
/* http://creativecommons.org/licenses/by-nc-sa/3.0/de/ */
/*------------------------------------------------------*/
/*                    JavaScript                        */
/********************************************************/

/******************** Settings **************************/
var psIGSettings = {
    controls: true, /* boolean - display controlbar */
    imageChange: 4000,  /* integer - Time, how long a photo should be shown before changing in milliseconds */
    titleOn: true, /* boolean - Show title at the beginning */
    randomize: true, /* boolean - Random images */
    thumbnailsStartShow: true, /* boolean - Show thumbnails at the beginning */
    keyboardActivate: true, /* boolean - Scroll photos with keyboard arrows */
    autoplay: false, /* boolean - Autoplay diashow */
    scaleNormalPhotosBigger: true, /* boolean - Resize smaller photos for gallery */
    scaleFullscreenPhotosBigger: true /* boolean - Resize smaller photos for fullscreen */
};

var psIGVelocity = {
    toggle: 400, /* integer - Time, how long thumbnailbar should toggle in milliseconds */
    fade: 800, /* integer - Time, how long image fade action takes in milliseconds */
    delayFadeESC: 2000, /* integer - Time, how long fullscreen close info should be displayed in milliseconds */
    delayToggleThumbnails: 2000, /* integer - Time, how long thumbnailbar should be displayed after onload the gallery in milliseconds */
    slideThumbnails: 400 /* integer - Time, how long thumbnail scrolling should take in milliseconds */
};

var psIGDescriptions = {
    titleSuffix: 'Photo ', /* string - Suffix of image title (e.g.: 'Photo '). If string is empty, number of the photo don't appear in the suffix of the title */
    leavingNote: 'Zum Verlassen \'ESC\' dr&uuml;cken' /* Note how to leave the fullscreen mode */
}

/*******  Don't change anything after this line  *******/
var psIGDOM={idPause:jQuery("#ps-image-gallery-pause"),idPlay:jQuery("#ps-image-gallery-play"),idPrev:jQuery("#ps-image-gallery-prev"),idNext:jQuery("#ps-image-gallery-next"),idControls:jQuery("#ps-image-gallery-controlbar"),idThumbs:jQuery("#ps-image-gallery-thumbnails"),idThumbsInner:jQuery("#ps-image-gallery-thumbnails-inner"),idThumbsOuter:jQuery("#ps-image-gallery-thumbnails-outer"),idThumbsLeft:jQuery("#ps-image-gallery-thumbnails-left"),idThumbsRight:jQuery("#ps-image-gallery-thumbnails-right"),idGallery:jQuery("#ps-image-gallery-gallery"),idDisplay:jQuery("#ps-image-gallery-display"),idTitle:jQuery("#ps-image-gallery-title"),idSlider:jQuery("#ps-image-gallery-slider"),idSliderbutton:jQuery("#ps-image-gallery-sliderbutton"),idTitleOff:jQuery("#ps-image-gallery-title-off"),idTitleOn:jQuery("#ps-image-gallery-title-on"),idFullscreenOn:jQuery("#ps-image-gallery-fullscreen-on"),idFullscreenOff:jQuery("#ps-image-gallery-fullscreen-off"),idCurrentphoto:jQuery("#ps-image-gallery-currentphoto"),idShowInfo:jQuery("#ps-image-gallery-showinfo"),idInfo:jQuery("#ps-image-gallery-info"),idLoadingCircle:jQuery("#ps-image-gallery-loading-circle"),images:jQuery("#ps-image-gallery-images img"),newDiv:jQuery("<div></div>"),newImg:jQuery("<img />"),body:jQuery("body")};var psIGDOMstrings={small:"ps-image-gallery-small",normal:"ps-image-gallery-normal",big:"ps-image-gallery-big",smallID:"#ps-image-gallery-small",normalID:"#ps-image-gallery-normal",bigID:"#ps-image-gallery-big"};var psIGGlobals={currentPhoto:0,countPhotos:0,orderPhotos:[],isMouseover:false,toggletimer:0,marginThumbs:20,isFullscreen:false,isInfo:false,isTitle:psIGSettings.titleOn,controlsActivate:true,loaded:false};var psIGinit={randomize:function(a,e){var b,c,d,f;for(b=a;b--;){psIGGlobals.orderPhotos[b]=b}if(e){for(b=(a*3);b--;){c=Math.floor(Math.random()*a);d=Math.floor(Math.random()*a);f=psIGGlobals.orderPhotos[c];psIGGlobals.orderPhotos[c]=psIGGlobals.orderPhotos[d];psIGGlobals.orderPhotos[d]=f}}},photoshowReady:function(){if(psIGSettings.controls){psIGDOM.idControls.show()}var a=psIGDOM.images.length;var b="1 / "+a;psIGDOM.idCurrentphoto.html(b);psIGDOM.idInfo.html('PS-Image-Gallery<br />Programmed by: Patrick Saar<br />Version: 1.2<br /><a href="http://www.patrick-saar.de" target="_blank" id="programmerlink">www.patrick-saar.de</a>');return a},mouseposition:function(){psIGDOM.idGallery.mousemove(function(a){psIGGlobals.isMouseover=true})},title:function(){if(!psIGSettings.titleOn){psIGControls.titleOff(0)}},thumbnails:function(){if(!psIGSettings.thumbnailsStartShow){psIGDOM.idThumbs.slideToggle(0)}},cssSize:function(){var b=psIGDOM.idGallery.width();var a=psIGDOM.idDisplay.height();psIGDOM.idTitle.css({width:b});psIGDOM.idThumbs.css({width:b});psIGDOM.idThumbsOuter.css({width:b-64});psIGDOM.idLoadingCircle.css({width:b,height:a})}};var psIGmethods={scalePhoto:function(d,h,c){var a;var b=psIGGlobals.isFullscreen;if(!b){a=psIGDOMstrings.normalID}else{a=psIGDOMstrings.bigID}var e=jQuery(a+d);var g=e.width();var f=e.height();if(!g||!f||!h||!c){setTimeout(function(){scalePhoto(d,h,c)},10)}else{e.css({width:"auto",height:"auto"});if(g/h<f/c){if(f>=c||(psIGSettings.scaleNormalPhotosBigger&&!b)||(psIGSettings.scaleFullscreenPhotosBigger&&b)){e.css({width:g*(c/f),height:c,"margin-left":-(g*(c/f))/2,"margin-top":-c/2})}}else{if(g>=h||(psIGSettings.scaleNormalPhotosBigger&&!b)||(psIGSettings.scaleFullscreenPhotosBigger&&b)){e.css({width:h,height:f*(h/g),"margin-left":-h/2,"margin-top":-(f*(h/g))/2})}}}},toggleThumbnails:function(a,b){psIGGlobals.toggletimer=setTimeout(function(){psIGDOM.idThumbs.stop().slideToggle(b,function(){psIGGlobals.toggletimer=false})},a)},getTitle:function(a){var b=psIGDOM.idTitle;var c=psIGDOM.images.eq(a).attr("data-title");if(!c||!psIGGlobals.isTitle){b.hide()}else{b.show()}b.html(c)},controlsInactive:function(a){psIGGlobals.controlsActivate=false;setTimeout(function(){psIGGlobals.controlsActivate=true},a)}};var psIGPhotoCreate={small:function(a){var h,g;var d=psIGDOM.newImg;for(var b=a;b--;){d.clone().prependTo("#ps-image-gallery-thumbnails-inner")}var c=jQuery("#ps-image-gallery-thumbnails-inner img");var b=0,e,f;for(b=a;b--;){e=psIGDOM.images.eq(psIGGlobals.orderPhotos[b]);f=c.eq(b);h=e.attr("data-title");g=e.attr("data-small-src");if(psIGDescriptions.titleSuffix!==""){f.attr({title:psIGDescriptions.titleSuffix+" "+(b+1)+" - "+h})}else{f.attr({title:h})}f.attr({src:g,id:psIGDOMstrings.small+b});f.click(function(){psIGThumbnailsControl.clicked(jQuery(this).index())})}jQuery(window).load(function(){var k=0,i,j=psIGGlobals.marginThumbs;for(b=0;b<a;b++){i=c.eq(b);i.attr({"data-left":-k});k+=i.width()+j}psIGDOM.idThumbsInner.css({width:k})})},normal:function(){var g;var b=psIGGlobals.currentPhoto;var a=psIGGlobals.countPhotos;var f,e;var d=psIGDOM.newImg;for(var c=b-1;c<=b+3;c++){if(c<0){f=a-1}else{if(c>a){f=0}else{f=c}}e=psIGDOM.images.eq(psIGGlobals.orderPhotos[f]);if(jQuery(psIGDOMstrings.normalID+f).length===0){if(e.attr("data-normal-src")){g=e.attr("data-normal-src");d.attr({src:g,id:psIGDOMstrings.normal+f}).clone().prependTo("#ps-image-gallery-display").hide()}else{if(e.attr("data-big-src")){g=e.attr("data-big-src");d.attr({src:g,id:psIGDOMstrings.normal+f}).clone().prependTo("#ps-image-gallery-display").hide()}else{g=e.attr("data-small-src");d.attr({src:g,id:psIGDOMstrings.normal+f}).clone().prependTo("#ps-image-gallery-display").hide()}}}}jQuery(psIGDOMstrings.normalID+b).bind("load",function(){if(!psIGGlobals.loaded){loaded()}})},big:function(){var g;var b=psIGGlobals.currentPhoto;var a=psIGGlobals.countPhotos;var f,e;var d=psIGDOM.newImg;for(var c=b-1;c<=b+3;c++){if(c<0){f=a-1}else{if(c>a){f=0}else{f=c}}e=psIGDOM.images.eq(psIGGlobals.orderPhotos[f]);if(jQuery(psIGDOMstrings.bigID+f).length===0){if(e.attr("data-big-src")){g=e.attr("data-big-src");d.attr({src:g,id:psIGDOMstrings.big+f}).clone().prependTo("#ps-image-gallery-fullscreen-bg").hide()}else{if(e.attr("data-normal-src")){g=e.attr("data-normal-src");d.attr({src:g,id:psIGDOMstrings.big+f}).clone().prependTo("#ps-image-gallery-fullscreen-bg").hide()}else{g=e.attr("data-small-src");d.attr({src:g,id:psIGDOMstrings.big+f}).clone().prependTo("#ps-image-gallery-fullscreen-bg").hide()}}}}}};var psIGControls={timeout:false,play:function(){var a=psIGDOM.idDisplay;var b=jQuery(window);psIGDOM.idPause.show();psIGDOM.idPlay.hide();this.timeout=setTimeout(function(){if(!psIGGlobals.isFullscreen){psIGControls.next(true,psIGDOMstrings.normalID,a.width(),a.height())}else{psIGControls.next(true,psIGDOMstrings.bigID,b.width(),b.height())}psIGControls.play()},(psIGSettings.imageChange))},pause:function(){psIGDOM.idPlay.show();psIGDOM.idPause.hide();if(this.timeout){clearTimeout(this.timeout)}},next:function(k,c,l,e){psIGPhotoCreate.normal();var f=psIGGlobals.currentPhoto;var h=f;var d=psIGVelocity.fade;var b=psIGGlobals.countPhotos;var a=psIGDOM.idLoadingCircle;if(k){this.pause()}jQuery(psIGDOMstrings.smallID+h).css({width:"auto"});f++;if(f>=b){f=0}a.show();var g=jQuery(c+f);jQuery.when(g.bind("load")).then(function(){var i=(f+1)+" / "+b;var j=psIGDOM.idThumbsInner;var m=psIGDOM.idThumbsOuter;psIGDOM.idCurrentphoto.html(i);psIGmethods.scalePhoto(f,l,e);var n=jQuery(psIGDOMstrings.smallID+f).attr("data-left");if(-n>j.width()-m.width()){n=-(j.width()-m.width())}j.animate({left:n},psIGVelocity.slideThumbnails);a.hide();jQuery(c+h).fadeOut(d);g.fadeIn(d);psIGmethods.getTitle(psIGGlobals.orderPhotos[f])});psIGGlobals.currentPhoto=f;if(psIGGlobals.isFullscreen){psIGPhotoCreate.big()}},prev:function(k,c,l,e){psIGPhotoCreate.normal();var f=psIGGlobals.currentPhoto;var h=f;var d=psIGVelocity.fade;var b=psIGGlobals.countPhotos;var a=psIGDOM.idLoadingCircle;if(k){this.pause()}jQuery(psIGDOMstrings.smallID+h).css({width:"auto"});f--;if(f<0){f=b-1}a.show();var g=jQuery(c+f);jQuery.when(g.bind("load")).then(function(){var i=(f+1)+" / "+b;var j=psIGDOM.idThumbsInner;var m=psIGDOM.idThumbsOuter;psIGDOM.idCurrentphoto.html(i);psIGmethods.scalePhoto(f,l,e);var n=jQuery(psIGDOMstrings.smallID+f).attr("data-left");if(-n>j.width()-m.width()){n=-(j.width()-m.width())}j.animate({left:n},psIGVelocity.slideThumbnails);a.hide();jQuery(c+h).fadeOut(d);g.fadeIn(d);psIGmethods.getTitle(psIGGlobals.orderPhotos[f])});psIGGlobals.currentPhoto=f;if(psIGGlobals.isFullscreen){psIGPhotoCreate.big()}},titleOff:function(a){if(!a){a=psIGVelocity.fade}psIGDOM.idTitleOn.show();psIGDOM.idTitleOff.hide();psIGDOM.idTitle.fadeOut(a);psIGGlobals.isTitle=false},titleOn:function(){psIGDOM.idTitleOff.show();psIGDOM.idTitleOn.hide();psIGDOM.idTitle.fadeIn(psIGVelocity.fade);psIGGlobals.isTitle=true},fullscreen:function(c){var a;if(c){var d=jQuery(window);jQuery('<div id="ps-image-gallery-fullscreen-bg"><div id="ps-image-gallery-fullscreen-esc">'+psIGDescriptions.leavingNote+"</div></div>").appendTo("body");jQuery('<div id="ps-image-gallery-loading-circle-fullscreen"><img src="images/ps-image-gallery-loader.gif" /></div>').show().appendTo("#ps-image-gallery-fullscreen-bg");psIGDOM.body.css({overflow:"hidden"});psIGPhotoCreate.big();psIGDOM.idControls.prependTo("#ps-image-gallery-fullscreen-bg").css({position:"absolute",left:0,bottom:0,"z-index":"1000001"});psIGDOM.idInfo.prependTo("#ps-image-gallery-fullscreen-bg").css({bottom:30});psIGDOM.idTitle.prependTo("#ps-image-gallery-fullscreen-bg").css({width:"100%","z-index":"1000001"});jQuery("#ps-image-gallery-fullscreen-esc").delay(psIGVelocity.delayFadeESC).fadeOut(psIGVelocity.fade);psIGGlobals.isFullscreen=true;psIGDOM.idFullscreenOff.show();psIGDOM.idFullscreenOn.hide();a=psIGGlobals.currentPhoto;jQuery(psIGDOMstrings.bigID+a).bind("load",function(){psIGmethods.scalePhoto(a,d.width(),d.height());jQuery("#ps-image-gallery-loading-circle-fullscreen").hide();jQuery(psIGDOMstrings.bigID+a).show()})}else{var b=psIGDOM.idDisplay;psIGDOM.body.css({overflow:"auto"});psIGGlobals.isFullscreen=false;jQuery("#ps-image-gallery-display > img").hide();a=psIGGlobals.currentPhoto;jQuery(psIGDOMstrings.normalID+a).show();psIGmethods.scalePhoto(a,b.width(),b.height());psIGDOM.idControls.prependTo("#ps-image-gallery-controlbar-wrapper").css({position:"",left:"",bottom:"","z-index":""});psIGDOM.idInfo.prependTo("#ps-image-gallery-info-wrapper").css({bottom:0});psIGDOM.idTitle.prependTo("#ps-image-gallery-display").css({width:b.css("width"),"z-index":"99"});jQuery("#ps-image-gallery-fullscreen-bg").remove();psIGDOM.idFullscreenOn.show();psIGDOM.idFullscreenOff.hide()}},showInfo:function(){if(!psIGGlobals.isInfo){psIGDOM.idInfo.fadeIn(psIGVelocity.fade,function(){psIGGlobals.isInfo=true})}else{psIGDOM.idInfo.fadeOut(psIGVelocity.fade,function(){psIGGlobals.isInfo=false})}}};var psIGThumbnailsControl={left:function(){psIGPhotoCreate.normal();var a=psIGDOM.idThumbsInner.width();var b=psIGDOM.idThumbsOuter.width();if(a>b){var c=parseInt(psIGDOM.idThumbsInner.css("left"));c=c+0.75*b;if(c>0){c=0}psIGDOM.idThumbsInner.animate({left:c},psIGVelocity.slideThumbnails)}},right:function(){psIGPhotoCreate.normal();var a=psIGDOM.idThumbsInner.width();var b=psIGDOM.idThumbsOuter.width();if(a>b){var c=parseInt(psIGDOM.idThumbsInner.css("left"));c=c-0.75*b;if(c<(-a+b)){c=-a+b}psIGDOM.idThumbsInner.animate({left:c},psIGVelocity.slideThumbnails)}},clicked:function(b){if(psIGGlobals.currentPhoto!==b){var c=psIGGlobals.currentPhoto;var d=jQuery(psIGDOMstrings.normalID+b);var a=psIGDOM.idLoadingCircle;psIGGlobals.currentPhoto=b;psIGControls.pause();psIGPhotoCreate.normal();jQuery(psIGDOMstrings.normalID+c).fadeOut(psIGVelocity.fade);a.show();jQuery.when(d.bind("load")).then(function(){var f=(b+1)+" / "+psIGGlobals.countPhotos;var e=psIGDOM.idDisplay;psIGDOM.idCurrentphoto.html(f);psIGmethods.scalePhoto(b,e.width(),e.height());a.hide();jQuery(psIGDOMstrings.normalID+b).fadeIn(psIGVelocity.fade);psIGmethods.getTitle(psIGGlobals.orderPhotos[b])})}}};psIGDOM.idPlay.click(function(){if(psIGGlobals.controlsActivate){psIGControls.play()}psIGmethods.controlsInactive(psIGVelocity.fade)});psIGDOM.idPause.click(function(){if(psIGGlobals.controlsActivate){psIGControls.pause()}psIGmethods.controlsInactive(psIGVelocity.fade)});psIGDOM.idNext.click(function(){if(psIGGlobals.controlsActivate){var a=psIGDOM.idDisplay;var b=jQuery(window);if(!psIGGlobals.isFullscreen){psIGControls.next(true,psIGDOMstrings.normalID,a.width(),a.height())}else{psIGControls.next(true,psIGDOMstrings.bigID,b.width(),b.height())}}psIGmethods.controlsInactive(psIGVelocity.fade)});psIGDOM.idPrev.click(function(){if(psIGGlobals.controlsActivate){var a=psIGDOM.idDisplay;var b=jQuery(window);if(!psIGGlobals.isFullscreen){psIGControls.prev(true,psIGDOMstrings.normalID,a.width(),a.height())}else{psIGControls.prev(true,psIGDOMstrings.bigID,b.width(),b.height())}}psIGmethods.controlsInactive(psIGVelocity.fade)});psIGDOM.idTitleOff.click(function(){psIGControls.titleOff()});psIGDOM.idTitleOn.click(function(){psIGControls.titleOn()});psIGDOM.idFullscreenOn.click(function(){psIGControls.fullscreen(true)});psIGDOM.idFullscreenOff.click(function(){psIGControls.fullscreen(false)});psIGDOM.idShowInfo.click(function(){psIGControls.showInfo()});psIGDOM.idThumbsLeft.click(function(){if(psIGGlobals.controlsActivate){psIGThumbnailsControl.left()}psIGmethods.controlsInactive(psIGVelocity.slideThumbnails)});psIGDOM.idThumbsRight.click(function(){if(psIGGlobals.controlsActivate){psIGThumbnailsControl.right()}psIGmethods.controlsInactive(psIGVelocity.slideThumbnails)});psIGDOM.idDisplay.hover(function(){if(psIGDOM.idThumbs.css("display")==="none"){psIGmethods.toggleThumbnails(0,psIGVelocity.toggle)}},function(){if(psIGDOM.idThumbs.css("display")!=="none"){psIGmethods.toggleThumbnails(0,psIGVelocity.toggle)}});jQuery(document).keyup(function(b){if(psIGGlobals.controlsActivate){var c=psIGGlobals.isFullscreen;var d=psIGSettings.keyboardActivate;var g=b.keyCode;if(g==27&&c){psIGControls.fullscreen(false)}else{if(g==37&&d&&!c){var a=psIGDOM.idDisplay;psIGControls.prev(true,psIGDOMstrings.normalID,a.width(),a.height())}else{if(g==39&&d&&!c){var a=psIGDOM.idDisplay;psIGControls.next(true,psIGDOMstrings.normalID,a.width(),a.height())}else{if(g==37&&d&&c){var h=jQuery(window);psIGControls.prev(true,psIGDOMstrings.bigID,h.width(),h.height())}else{if(g==39&&d&&c){var h=jQuery(window);psIGControls.next(true,psIGDOMstrings.bigID,h.width(),h.height())}}}}}psIGmethods.controlsInactive(psIGVelocity.fade)}});jQuery(window).resize(function(){if(psIGGlobals.isFullscreen){psIGmethods.scalePhoto(psIGGlobals.currentPhoto,jQuery(window).width(),jQuery(window).height())}});jQuery(document).ready(function(){psIGDOM.idLoadingCircle.show();psIGDOM.idThumbs.show();psIGinit.cssSize();psIGinit.title();psIGGlobals.countPhotos=psIGinit.photoshowReady();psIGinit.randomize(psIGGlobals.countPhotos,psIGSettings.randomize);psIGPhotoCreate.small(psIGGlobals.countPhotos);psIGPhotoCreate.normal();psIGmethods.getTitle(psIGGlobals.orderPhotos[0])});function loaded(){psIGmethods.scalePhoto(0,psIGDOM.idDisplay.width(),psIGDOM.idDisplay.height());psIGDOM.idLoadingCircle.hide();jQuery(psIGDOMstrings.normalID+"0").show();if(psIGSettings.thumbnailsStartShow){psIGmethods.toggleThumbnails(psIGVelocity.delayToggleThumbnails,psIGVelocity.toggle)}else{psIGDOM.idThumbs.hide()}if(psIGSettings.autoplay){psIGControls.play()}psIGGlobals.loaded=true};