(function ($) {
    $.fn.psMobileGallery = function (settings) {
        var currentIndex;
        var numberOfImages;
        var width, height;
        var overflow = $('body').css('overflow');
        var mobileGallery = $(this);

        mobileGallery.click(function () {

            $(document).on('touchmove', function (e) { e.preventDefault(); });

            $('body').css('overflow', 'hidden');
            width = $(window).width();
            height = $(window).height();

            currentIndex = mobileGallery.index(this);
            numberOfImages = mobileGallery.length;

            create();

            return false;
        });

        $(document).ready(function () {

            $.event.special.swipe.durationThreshold = 2000;
            $.event.special.swipe.verticalDistanceThreshold = 100;
            $.event.special.swipe.horizontalDistanceThreshold = 50;

            $(document).on('swipeleft', '#ps-mobile-gallery-over', function (event) {
                swipeleft();
            });

            $(document).on('swiperight', '#ps-mobile-gallery-over', function (event) {
                swiperight();
            });
            $(document).on('click', '#ps-mobile-gallery-over', function () {
                close();
            });

            $(window).on('orientationchange', function () {
                recalculate();
            });

            $(window).on('resize', function () {
                recalculate();
            });

            if (settings.loadingCircle) {
                $('<img/>')[0].src = settings.loadingCircle;
            }
        });

        function recalculate() {
            width = $(window).width();
            height = $(window).height();
            scaleImage($('.ps-mobile-gallery-image'), true);

            $('#ps-mobile-gallery, #ps-mobile-gallery-over, .ps-mobile-gallery-item').css({
                'display': 'block',
                'width': width,
                'height': height
            });

            $('#ps-mobile-gallery-belt').css({
                'width': width * (numberOfImages + 1),
                'height': height,
                'margin-left': -width * currentIndex
            });
        }

        function create() {
            var src, alt;
            var num = numberOfImages;
            var index = currentIndex;

            setDefaults();

            $('<div id="ps-mobile-gallery"><div id="ps-mobile-gallery-over"></div><div id="ps-mobile-gallery-belt"></div></div>').prependTo('body');

            $('#ps-mobile-gallery').css('background', settings.backgroundColor);

            $('#ps-mobile-gallery, #ps-mobile-gallery-over').css({
                'display': 'block',
                'width': width,
                'height': height
            });

            loading();

            $('#ps-mobile-gallery-belt').css({
                'width': width * (num + 1),
                'height': height,
                'margin-left': -width * index
            });

            appendItems();

            for (var i = 0; i < 5; i++) {
                append((num + index + i - 2) % num, null, true);
            }

            loadingDone($('.ps-mobile-gallery-image'));
        }

        function setDefaults() {
            settings.backgroundColor = '#333';
            settings.scaleSmallImagesBigger = false;
        }

        function appendItems() {

            for (var i = 0; i < numberOfImages; i++) {
                $('<div class="ps-mobile-gallery-item" id="ps-mobile-gallery-item-' + i + '"></div>').appendTo('#ps-mobile-gallery-belt');
            }
            $('<div class="ps-mobile-gallery-item" id="ps-mobile-gallery-item-' + numberOfImages + '"></div>').appendTo('#ps-mobile-gallery-belt');
            append(0, numberOfImages);

            $('.ps-mobile-gallery-item').css({
                'width': width,
                'height': height
            });
        }

        function close() {
            $('body').css('overflow', overflow);

            $(document).unbind('touchmove');

            $('#ps-mobile-gallery').fadeOut(400, function () {
                $('#ps-mobile-gallery').remove();
            })
        }

        function loading() {
            $('<div id="ps-mobile-gallery-loading-wrap"></div>').appendTo('#ps-mobile-gallery');

            $('#ps-mobile-gallery-loading-wrap').css('background', settings.backgroundColor);

            if (settings.loadingCircle) {
                $('<img src="' + settings.loadingCircle + '" id="ps-mobile-gallery-loading" />').appendTo('#ps-mobile-gallery-loading-wrap');
                var loadingImg = $('#ps-mobile-gallery-loading');
                loadingImg.css({
                    'position': 'absolute',
                    'top': '50%',
                    'left': '50%',
                    'margin-left': loadingImg.width() / (-2),
                    'margin-top': loadingImg.height() / (-2),
                    'width': loadingImg.width(),
                    'height': loadingImg.height(),
                    'z-index': 1
                });
            }
        }

        function loadingDone(image) {
            if ($('#ps-mobile-gallery-loading-wrap').length > 0) {
                var int = setInterval(function () {
                    var loaded = 0;
                    image.each(function () {
                        if ($(this).attr('data-loaded') == 'true') {
                            loaded++;
                        }
                    });
                    if (loaded == image.length) {
                        $('#ps-mobile-gallery-loading-wrap').fadeOut(200);
                        clearInterval(int);
                    }
                }, 100);
            }
        }

        function swipe(direction) {
            var offset = parseFloat($('#ps-mobile-gallery-belt').css('margin-left'));
            var width = parseFloat($('.ps-mobile-gallery-item').css('width'));
            if (offset == 0 && direction == -1) {
                offset = -(width * numberOfImages);
            } else if (-offset == width * numberOfImages && direction == 1) {
                offset = 0;
            }
            $('#ps-mobile-gallery-belt').css({ 'margin-left': offset });
            $('#ps-mobile-gallery-belt').animate({ 'margin-left': offset - direction * width }, 400);
        }

        function swipeleft() {
            currentIndex = (currentIndex + 1) % numberOfImages;
            append((currentIndex + 2) % numberOfImages);
            swipe(1);
            if ($('#ps-mobile-gallery-image-' + currentIndex).attr('data-loaded') != 'true') {
                loading();
            }
        }

        function swiperight() {
            currentIndex = (numberOfImages + currentIndex - 1) % numberOfImages;
            prepend((numberOfImages + currentIndex - 2) % numberOfImages);
            swipe(-1);
            if ($('#ps-mobile-gallery-image-' + currentIndex).attr('data-loaded') != 'true') {
                loading();
            }
        }

        function remove(index) {
            $('.ps-mobile-gallery-item').eq(index).remove();
        }

        function append(index, id, init) {
            if (init == null) {
                init = false;
            }
            if (!$('#ps-mobile-gallery-item-' + index).empty()) {
                return;
            }

            if (!id) {
                id = index;
            }

            var source = mobileGallery.eq(index).attr('href');
            $('<img src="' + source + '" class="ps-mobile-gallery-image" id="ps-mobile-gallery-image-' + id + '" />').css({ 'display': 'none' }).appendTo('#ps-mobile-gallery-item-' + id);
            scaleImage($('#ps-mobile-gallery-image-' + id), false);

            if (init === false) {
                loadingDone($('#ps-mobile-gallery-image-' + id));
            }
        }

        function prepend(index, init) {
            if (init == null) {
                init = false;
            }
            if (!$('#ps-mobile-gallery-item-' + index).empty()) {
                return;
            }

            var source = mobileGallery.eq(index).attr('href');
            $('<img src="' + source + '" class="ps-mobile-gallery-image" id="ps-mobile-gallery-image-' + index + '" />').css({ 'display': 'none' }).appendTo('#ps-mobile-gallery-item-' + index);
            scaleImage($('#ps-mobile-gallery-image-' + index), false);

            if (init === false) {
                loadingDone($('#ps-mobile-gallery-image-' + index));
            }
        }

        function scaleImage(image, event) {
            image.each(function () {
                if (event == false) {
                    $(this).load(function () {
                        var element = $(this);
                        scale(element);
                        element.attr({ 'data-loaded': 'true' });
                    });
                }
                else {
                    scale($(this));
                }
            });
        }

        function scale(element) {
            var imageWidth = element.width();
            var imageHeight = element.height();
            var boxWidth = width;
            var boxHeight = height;

            if (imageWidth / boxWidth < imageHeight / boxHeight) {
                if (imageHeight >= boxHeight || settings.scaleSmallImagesBigger === true) {
                    element.css({ 'width': imageWidth * (boxHeight / imageHeight), 'height': boxHeight });
                }
            }
            else {
                if (imageWidth >= boxWidth || settings.scaleSmallImagesBigger === true) {
                    element.css({ 'width': boxWidth, 'height': imageHeight * (boxWidth / imageWidth) });
                }
            }

            element.css({
                'position': 'absolute',
                'top': '50%',
                'left': '50%',
                'margin-left': -(parseFloat(element.css('width')) / 2),
                'margin-top': -(parseFloat(element.css('height')) / 2),
                'display': 'block'
            });
        }
    }
})(jQuery);

$(function () {
    // Use PS Mobile Gallery only on mobile devices
    //if (navigator.userAgent.search(/(Android|iPhone|iPad|iPod|webOS|Windows Phone|Blackberry)/i) != -1) {
        $('.ps-mobile-gallery').psMobileGallery({
            backgroundColor: '#000',
			scaleSmallImagesBigger: true,
			loadingCircle: 'jquery-ps-mobile-gallery/ps-mobile-gallery-loader.gif'
		});
    //}
});