// -------------------------------------------------------------------
// ------------- Autor: Patrick Saar - www.patrick-saar.de -----------
// ---------------- jQuery Bilder skalieren v. 1.0 -------------------
// ------------------ Copyright 2012 Patrick Saar --------------------
// -------------------------------------------------------------------

function scaleImage(image, box, scaleSmallImagesBigger) {
    // Dimensionen des Bildes und der Box lokal speichern
    var imageWidth = image.width();
    var imageHeight = image.height();
    var boxWidth = box.width();
    var boxHeight = box.height();

    // Je nach Seitenverhaeltnis des Bildes skalieren
    if (imageWidth / boxWidth < imageHeight / boxHeight) {
        if (imageHeight >= boxHeight || scaleSmallImagesBigger === true) {
            // Bild skalieren
            image.css({ 'width': imageWidth * (boxHeight / imageHeight), 'height': boxHeight });
        }
    }
    else {
        if (imageWidth >= boxWidth || scaleSmallImagesBigger === true) {
            // Bild skalieren
            image.css({ 'width': boxWidth, 'height': imageHeight * (boxWidth / imageWidth) });
        }
    }
    // Bild in Box zentrieren
    image.css({ 
        'position': 'absolute',
        'top': '50%',
        'left': '50%',
        'margin-left': -(parseInt(image.css('width')) / 2),
        'margin-top': -(parseInt(image.css('height')) / 2)
     });
}

// Bild skalieren, nachdem die Webseite und viel wichtiger das entsprechende Bild geladen wurde.
$(window).load(function() {
    scaleImage($('#img'), $(window), true);
});

// Bild bei Veraenderung der Browserfenstergroesse erneut skalieren
$(window).resize(function() {
    scaleImage($('#img'), $(window), true);
}); 